<?php
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);
date_default_timezone_set('Asia/Dhaka');

$DB_HOST = 'localhost';
$DB_USER = 'trustpaybd_fighttwolive';
$DB_PASS = 'trustpaybd_fighttwolive';
$DB_NAME = 'trustpaybd_fighttwolive';

$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($conn->connect_error) {
    die("Database Connection Failed: " . $conn->connect_error);
}

$app = [
    'app_name'   => 'War Zone BD',
    'logo'       => '/admin/uploads/default-logo.png',
    'app_link'   => '#',
    'video_id'   => '',
    'telegram_id'=> '#',
    'email'      => 'support@example.com',
];

$sql = "SELECT * FROM app_settings LIMIT 1";
$res = $conn->query($sql);

if ($res && $row = $res->fetch_assoc()) {
    if (!empty($row['app_name']))    $app['app_name'] = $row['app_name'];

    if (!empty($row['logo'])) {
        if (strpos($row['logo'], '/') === false) {
            $app['logo'] = 'admin/uploads/' . $row['logo'];
        } else {
            $app['logo'] = $row['logo'];
        }
    }

    if (!empty($row['apk_file'])) {
        if (strpos($row['apk_file'], '/') === false) {
            $app['app_link'] = 'admin/uploads/' . $row['apk_file'];
        } else {
            $app['app_link'] = $row['apk_file'];
        }
    }

    if (!empty($row['video_id']))    $app['video_id'] = $row['video_id'];
    if (!empty($row['telegram_id'])) $app['telegram_id'] = $row['telegram_id'];
    if (!empty($row['email']))       $app['email'] = $row['email'];
}

function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
$year = date('Y');
?>
<!doctype html>
<html lang="bn">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />

  <title><?= e($app['app_name']) ?> | বাংলাদেশে সেরা স্পোর্টস টুর্নামেন্ট অ্যাপ</title>
  
  <meta name="description" content="<?= e($app['app_name']) ?> - আমাদের অফিসিয়াল স্পোর্টস টুর্নামেন্ট অ্যাপ, যেখানে আপনি পাবেন ম্যাচ আপডেট, রেজাল্ট ও আরও অনেক কিছু।" />
  <meta name="keywords" content="sports app, figth two live, fight 2 live, freefire tour, <?= e($app['app_name']) ?>, Bangladesh app, APK download">
  <meta name="author" content="Android Artist">
  <meta name="robots" content="index, follow">

  <meta property="og:title" content="<?= e($app['app_name']) ?> | বাংলাদেশে সেরা টুর্নামেন্ট অ্যাপ" />
  <meta property="og:description" content="ডাউনলোড করুন <?= e($app['app_name']) ?> — অফিসিয়াল স্পোর্টস টুর্নামেন্ট অ্যাপ।" />
  <meta property="og:type" content="website" />
  <meta property="og:url" content="https://<?= $_SERVER['HTTP_HOST']; ?>" />
  <meta property="og:image" content="https://<?= $_SERVER['HTTP_HOST']; ?>/<?= e($app['logo']); ?>" />
  <meta property="og:site_name" content="<?= e($app['app_name']) ?>" />

  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="<?= e($app['app_name']) ?> | Official Sports App" />
  <meta name="twitter:description" content="Download <?= e($app['app_name']) ?> to get live updates and tournament details!" />
  <meta name="twitter:image" content="https://<?= $_SERVER['HTTP_HOST']; ?>/<?= e($app['logo']); ?>" />

  <link rel="icon" href="<?= e($app['logo']) ?>" type="image/png" />

  <meta name="theme-color" content="#007bff" />
  <style>
    :root {
      --primary:#007bff;
      --dark:#0f172a;
      --light:#f9fafb;
    }
    *{box-sizing:border-box;margin:0;padding:0;font-family:"Poppins",sans-serif;}
    body{background:var(--light);color:var(--dark);line-height:1.6;}
    .wrap{max-width:1100px;margin:auto;padding:0 1rem;}
    header.site-header{background:var(--dark);color:#fff;padding:1rem 0;}
    .brand{display:flex;align-items:center;gap:.75rem;}
    .brand-logo{width:50px;height:50px;object-fit:cover;border-radius:12px;}
    .brand-title{font-size:1.25rem;font-weight:600;}
    .brand-sub{font-size:.85rem;color:#ccc;}
    .top-nav{margin-left:auto;}
    .nav-btn{background:var(--primary);color:#fff;text-decoration:none;padding:.5rem 1rem;border-radius:8px;display:inline-flex;align-items:center;gap:.4rem;}
    .hero{padding:3rem 0;display:flex;align-items:center;justify-content:center;}
    .hero-card{display:grid;grid-template-columns:1fr 1fr;align-items:center;gap:2rem;}
    .hero-left h1{font-size:1.8rem;margin-bottom:1rem;}
    .hero-left p{margin-bottom:1.5rem;color:#555;}
    .btn{display:inline-flex;align-items:center;gap:.4rem;border:none;text-decoration:none;padding:.75rem 1.25rem;border-radius:8px;font-weight:500;cursor:pointer;}
    .btn-primary{background:var(--primary);color:#fff;}
    .btn-outline{border:2px solid var(--primary);color:var(--primary);}
    .phone-mock{width:230px;height:460px;background:#000;border-radius:24px;overflow:hidden;margin:auto;}
    .phone-mock img{width:100%;height:100%;object-fit:cover;}
    .stats{background:#fff;padding:2rem 0;margin:2rem 0;}
    .grid-3{display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:1rem;text-align:center;}
    .stat-card{background:var(--light);padding:1.5rem;border-radius:12px;}
    .stat-num{font-size:1.5rem;font-weight:700;color:var(--primary);}
    .section-title{text-align:center;font-size:1.5rem;margin-bottom:1rem;}
    .video-frame iframe{width:100%;height:300px;border-radius:12px;}
    .features{background:#fff;padding:2rem 0;}
    .grid-4{display:grid;grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:1rem;text-align:center;}
    .feature{background:var(--light);padding:1.5rem;border-radius:12px;}
    .feature-emoji{font-size:2rem;}
    footer.site-footer{background:var(--dark);color:#fff;padding:1.5rem 0;text-align:center;}
    .contact-buttons{display:flex;justify-content:center;gap:1rem;margin-bottom:1rem;flex-wrap:wrap;}
    .small-btn{display:inline-flex;align-items:center;gap:.4rem;background:#fff;color:var(--dark);padding:.5rem .75rem;border-radius:8px;font-size:.9rem;text-decoration:none;}
    .small-btn.telegram{background:#0088cc;color:#fff;}
    .footer-bottom{font-size:.85rem;color:#ccc;}
    @media(max-width:768px){
      .hero-card{grid-template-columns:1fr;text-align:center;}
      .hero-left{order:2;}
      .hero-right{order:1;}
      .phone-mock{width:180px;height:360px;}
    }
  </style>
</head>
<body>

<header class="site-header">
  <div class="wrap" style="display:flex;justify-content:space-between;align-items:center;">
    <div class="brand">
      <img src="<?= e($app['logo']) ?>" alt="<?= e($app['app_name']) ?>" class="brand-logo">
      <div class="brand-text">
        <div class="brand-title"><?= e($app['app_name']) ?></div>
        <div class="brand-sub">বাংলাদেশের সেরা টুর্নামেন্ট</div>
      </div>
    </div>
    <nav class="top-nav">
      <a class="nav-btn" href="<?= e($app['app_link']) ?>" download>
        <svg width="18" height="18" viewBox="0 0 24 24" fill="none"><path d="M12 3v10" stroke="#fff" stroke-width="2" stroke-linecap="round"/><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4" stroke="#fff" stroke-width="2"/><path d="M7 10l5 5 5-5" stroke="#fff" stroke-width="2"/></svg>Download
      </a>
    </nav>
  </div>
</header>

<main>
  <section class="hero">
    <div class="wrap hero-card">
      <div class="hero-left">
        <div class="logo-large">
          <img src="<?= e($app['logo']) ?>" alt="App Logo" style="width:90px;height:90px;border-radius:16px;">
        </div>
        <h1>বাংলাদেশের সেরা গেমিং টুর্নামেন্ট প্ল্যাটফর্ম</h1>
        <p>প্রতিদিন টুর্নামেন্ট খেলে হাজার হাজার টাকা আয় করতে এখনই ডাউনলোড করুন আমাদের অফিসিয়াল অ্যাপ।</p>
        <div class="hero-ctas">
          <a class="btn btn-primary" href="<?= e($app['app_link']) ?>" download>
            <svg width="18" height="18" viewBox="0 0 24 24" fill="none"><path d="M12 3v10" stroke="#fff" stroke-width="2"/><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4" stroke="#fff" stroke-width="2"/><path d="M7 10l5 5 5-5" stroke="#fff" stroke-width="2"/></svg>
            অ্যাপ ডাউনলোড
          </a>
        </div>
      </div>
    </div>
  </section>

  <section class="stats">
    <div class="wrap grid-3">
      <div class="stat-card"><div class="stat-num">30K+</div><div class="stat-label">Downloads</div></div>
      <div class="stat-card"><div class="stat-num">20K+</div><div class="stat-label">Users</div></div>
      <div class="stat-card"><div class="stat-num">10K+</div><div class="stat-label">Matches Hosted</div></div>
    </div>
  </section>

  <?php if (!empty($app['video_id'])): ?>
  <section id="video" class="video-wrap">
    <div class="wrap">
      <h2 class="section-title">কিভাবে খেলবেন?</h2>
      <div class="video-frame">
        <iframe src="https://www.youtube.com/embed/<?= e($app['video_id']) ?>" allowfullscreen></iframe>
      </div>
    </div>
  </section>
  <?php endif; ?>

  <section id="features" class="features">
    <div class="wrap grid-4">
      <div class="feature"><div class="feature-emoji">⚡</div><h4>দৈনিক টুর্নামেন্ট</h4><p>রাত-দিনে বিভিন্ন টাইমের টুর্নামেন্ট — অংশগ্রহণ করে পুরস্কার জিতুন।</p></div>
      <div class="feature"><div class="feature-emoji">🏆</div><h4>আকর্ষণীয় পুরস্কার</h4><p>নগদ টাকা ও ইন-গেম পুরস্কার — জয়ীরা পাবে তাৎক্ষণিক রিওয়ার্ড।</p></div>
      <div class="feature"><div class="feature-emoji">💰</div><h4>দ্রুত ক্যাশ আউট</h4><p>বিকাশ/রকেটের মাধ্যমে দ্রুত টাকা তুলে নিন—সহজ ও নিরাপদ।</p></div>
      <div class="feature"><div class="feature-emoji">🎮</div><h4>প্লেয়াররা</h4><p>সেরা প্লেয়ারদের সাথে প্রতিদ্বন্দ্বিতা করে নিজের স্কিল যাচাই করুন।</p></div>
    </div>
  </section>
</main>

<footer class="site-footer">
  <div class="wrap footer-top">
    <div class="contact-buttons">
      <a class="small-btn" href="mailto:<?= e($app['email']) ?>">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M3 7.5v9A2.5 2.5 0 0 0 5.5 19h13a2.5 2.5 0 0 0 2.5-2.5v-9" stroke="#0f172a" stroke-width="1.25"/><path d="M21 7.5L12 13 3 7.5" stroke="#0f172a" stroke-width="1.25"/></svg>Email
      </a>
      <a class="small-btn telegram" href="<?= e($app['telegram_id']) ?>" target="_blank">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="#fff"><path d="M22 3L2 11.5 7 14l3.5-1.8L21 21z" fill="#fff"/></svg>Telegram
      </a>
    </div>
  </div>
  <div class="wrap footer-bottom">
    <div class="copyright">© <?= $year ?> <?= e($app['app_name']) ?> · Developed by Android Artist</div>
  </div>
</footer>

</body>
</html>
